/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.util.QName;
import java.util.Vector;

public abstract class ContainedContainerNode
extends ContainedNode
implements ContainerNode {
    public Vector _contents = new Vector();

    public ContainedContainerNode(int kind) {
        super(kind);
    }

    public Vector contents() {
        return this._contents;
    }

    public Node define(int type, String name, String repId, String version, String comment) {
        return Node.define(type, name, this, repId, version, comment, this._contents);
    }

    public Vector find(String name, int depth, int type, boolean excludeInherited) {
        return Node.find(this._contents, name, depth, type, excludeInherited);
    }

    public ContainedNode lookup(QName qname, boolean local) {
        int len = this._contents.size();
        for (int i = 0; i < len; ++i) {
            ContainedNode c = (ContainedNode)this._contents.elementAt(i);
            if (!c._name.equalsIgnoreCase(qname._s)) continue;
            if (!c._name.equals(qname._s)) {
                c.warnCaseViolation(qname._s);
            }
            if (qname._next == null) {
                return c;
            }
            if (c.isContainer()) {
                return ((ContainerNode)((Object)c)).lookup(qname._next, true);
            }
            this._repository._ER.error("Comp.AST.NotAContainer", new Object[]{qname._s, qname._next._s});
            return c;
        }
        return local ? null : this._container.lookup(qname, false);
    }

    public ContainedNode lookup(String name, boolean local) {
        if (this._name == null) {
            return null;
        }
        int len = this._contents.size();
        for (int i = 0; i < len; ++i) {
            ContainedNode c = (ContainedNode)this._contents.elementAt(i);
            if (!c._name.equalsIgnoreCase(name)) continue;
            return c;
        }
        return local ? null : this._container.lookup(name, false);
    }

    public boolean remove() {
        if (this._contents == null || this._contents.size() == 0) {
            super.remove();
            return true;
        }
        this._repository._ER.error("Comp.AST.containerNotEmpty", this._fullName);
        return false;
    }
}

